/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.util;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.ParseException;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.das2.graph.DasDevicePosition;
import org.das2.util.StringSchemeEditor;

public class LayoutStringSchemeEditor
extends JPanel
implements StringSchemeEditor {
    boolean both;
    private JTextField bottomRightEms;
    private JTextField bottomRightPercent;
    private JTextField bottomRightPx;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel2;
    private JTextField jTextField1;
    private JLabel leftTopPositionLabel;
    private JPanel rightBottomPanel;
    private JLabel rightBottomPositionLabel;
    private JTextField topLeftEms;
    private JTextField topLeftPercent;
    private JTextField topLeftPx;

    public LayoutStringSchemeEditor(boolean both, String orient) {
        this.initComponents();
        this.both = both;
        if (!both) {
            this.rightBottomPanel.setVisible(false);
            this.leftTopPositionLabel.setText("Position:");
        }
        if (orient.length() == 1) {
            switch (orient) {
                case "H": {
                    this.leftTopPositionLabel.setText("Left Position");
                    this.rightBottomPositionLabel.setText("Right Position");
                    break;
                }
                case "V": {
                    this.leftTopPositionLabel.setText("Top Position");
                    this.rightBottomPositionLabel.setText("Bottom Position");
                    break;
                }
                case "T": {
                    this.leftTopPositionLabel.setText("Top Position");
                    break;
                }
                case "B": {
                    this.leftTopPositionLabel.setText("Bottom Position");
                    break;
                }
                case "L": {
                    this.leftTopPositionLabel.setText("Left Position");
                    break;
                }
                case "R": {
                    this.leftTopPositionLabel.setText("Right Position");
                    break;
                }
            }
        }
    }

    private void initComponents() {
        this.jLabel15 = new JLabel();
        this.jLabel16 = new JLabel();
        this.jTextField1 = new JTextField();
        this.rightBottomPanel = new JPanel();
        this.rightBottomPositionLabel = new JLabel();
        this.jLabel11 = new JLabel();
        this.bottomRightPercent = new JTextField();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.bottomRightEms = new JTextField();
        this.jLabel14 = new JLabel();
        this.jLabel9 = new JLabel();
        this.bottomRightPx = new JTextField();
        this.jLabel10 = new JLabel();
        this.jPanel2 = new JPanel();
        this.leftTopPositionLabel = new JLabel();
        this.jLabel4 = new JLabel();
        this.topLeftPercent = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel5 = new JLabel();
        this.topLeftEms = new JTextField();
        this.jLabel6 = new JLabel();
        this.topLeftPx = new JTextField();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel15.setText("<html>Das2 positions components using relative positions<br>with offsets in pixels or in ems (the font height).");
        this.jLabel16.setText("Layout String: ");
        this.jTextField1.setText("0%,100%+3em");
        this.jTextField1.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LayoutStringSchemeEditor.this.jTextField1FocusLost(evt);
            }
        });
        this.rightBottomPositionLabel.setText("Right/Bottom Position:");
        this.jLabel11.setText("Relative to parent:");
        this.bottomRightPercent.setText("100");
        this.bottomRightPercent.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LayoutStringSchemeEditor.this.bottomRightPercentFocusLost(evt);
            }
        });
        this.jLabel12.setText("%");
        this.jLabel13.setText("Shift additional em-height:");
        this.bottomRightEms.setText("3");
        this.bottomRightEms.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LayoutStringSchemeEditor.this.bottomRightEmsFocusLost(evt);
            }
        });
        this.jLabel14.setText("em");
        this.jLabel9.setText("Shift additional pixels or points:");
        this.jLabel9.setToolTipText("Points and pixels are the same right now, but this may change and both are supported.");
        this.bottomRightPx.setText("0");
        this.bottomRightPx.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LayoutStringSchemeEditor.this.bottomRightPxFocusLost(evt);
            }
        });
        this.jLabel10.setText("px");
        GroupLayout rightBottomPanelLayout = new GroupLayout(this.rightBottomPanel);
        this.rightBottomPanel.setLayout(rightBottomPanelLayout);
        rightBottomPanelLayout.setHorizontalGroup(rightBottomPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(rightBottomPanelLayout.createSequentialGroup().addContainerGap().addGroup(rightBottomPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(rightBottomPanelLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(rightBottomPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel11).addComponent(this.jLabel13).addComponent(this.jLabel9).addGroup(rightBottomPanelLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(rightBottomPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(rightBottomPanelLayout.createSequentialGroup().addComponent(this.bottomRightPercent, -2, 48, -2).addGap(4, 4, 4).addComponent(this.jLabel12)).addGroup(rightBottomPanelLayout.createSequentialGroup().addComponent(this.bottomRightEms, -2, 55, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel14)).addGroup(rightBottomPanelLayout.createSequentialGroup().addComponent(this.bottomRightPx, -2, 48, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel10)))))).addComponent(this.rightBottomPositionLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        rightBottomPanelLayout.setVerticalGroup(rightBottomPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(rightBottomPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.rightBottomPositionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(rightBottomPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bottomRightPercent, -2, -1, -2).addComponent(this.jLabel12)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel13).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(rightBottomPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bottomRightEms, -2, -1, -2).addComponent(this.jLabel14)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(rightBottomPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.bottomRightPx, -2, -1, -2).addComponent(this.jLabel10)).addContainerGap(-1, Short.MAX_VALUE)));
        this.leftTopPositionLabel.setText("Left/Top Position:");
        this.jLabel4.setText("%");
        this.topLeftPercent.setText("0");
        this.topLeftPercent.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LayoutStringSchemeEditor.this.topLeftPercentFocusLost(evt);
            }
        });
        this.topLeftPercent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutStringSchemeEditor.this.topLeftPercentActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Relative to parent:");
        this.jLabel5.setText("Shift additional em-height:");
        this.topLeftEms.setText("0");
        this.topLeftEms.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LayoutStringSchemeEditor.this.topLeftEmsFocusLost(evt);
            }
        });
        this.topLeftEms.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutStringSchemeEditor.this.topLeftEmsActionPerformed(evt);
            }
        });
        this.jLabel6.setText("em");
        this.topLeftPx.setText("0");
        this.topLeftPx.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LayoutStringSchemeEditor.this.topLeftPxFocusLost(evt);
            }
        });
        this.jLabel7.setText("Shift additional pixels or points:");
        this.jLabel7.setToolTipText("Points and pixels are the same right now, but this may change and both are supported.");
        this.jLabel8.setText("px");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(12, 12, 12).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel5).addGroup(jPanel2Layout.createSequentialGroup().addGap(12, 12, 12).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.topLeftEms, -2, 55, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.topLeftPercent, -2, 48, -2).addGap(4, 4, 4).addComponent(this.jLabel4)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.topLeftPx, -2, 48, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8))))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 37, -2)).addComponent(this.jLabel7, GroupLayout.Alignment.TRAILING))).addComponent(this.leftTopPositionLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(0, this.topLeftEms, this.topLeftPercent, this.topLeftPx);
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.leftTopPositionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.topLeftPercent, -2, -1, -2).addComponent(this.jLabel4)).addGap(12, 12, 12).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.topLeftEms, -2, -1, -2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.topLeftPx, -2, -1, -2).addComponent(this.jLabel8)).addContainerGap(24, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rightBottomPanel, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel15, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.jLabel16).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField1, -2, 305, -2))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel15, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel16).addComponent(this.jTextField1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.rightBottomPanel, -1, -1, Short.MAX_VALUE)).addContainerGap(21, Short.MAX_VALUE)));
    }

    private void topLeftEmsActionPerformed(ActionEvent evt) {
    }

    private void jTextField1FocusLost(FocusEvent evt) {
        this.parseSpec();
    }

    private void topLeftPercentFocusLost(FocusEvent evt) {
        this.formatSpec();
    }

    private void topLeftEmsFocusLost(FocusEvent evt) {
        this.formatSpec();
    }

    private void topLeftPxFocusLost(FocusEvent evt) {
        this.formatSpec();
    }

    private void bottomRightPercentFocusLost(FocusEvent evt) {
        this.formatSpec();
    }

    private void bottomRightEmsFocusLost(FocusEvent evt) {
        this.formatSpec();
    }

    private void bottomRightPxFocusLost(FocusEvent evt) {
        this.formatSpec();
    }

    private void topLeftPercentActionPerformed(ActionEvent evt) {
        this.formatSpec();
    }

    private void parseSpec() {
        double[] dd2;
        String[] ss = this.jTextField1.getText().split(",");
        try {
            dd2 = DasDevicePosition.parseLayoutStr((String)ss[0]);
            if (dd2[0] != 0.0 || dd2[1] == 0.0 && dd2[2] == 0.0) {
                this.topLeftPercent.setText(String.format("%.2f", dd2[0] * 100.0));
            }
            if (dd2[1] != 0.0) {
                this.topLeftEms.setText(String.format("%.1f", dd2[1]));
            }
            if (dd2[2] != 0.0) {
                this.topLeftPx.setText(String.format("%d", (int)dd2[2]));
            }
        }
        catch (ParseException dd2) {
            // empty catch block
        }
        if (ss.length == 2) {
            try {
                dd2 = DasDevicePosition.parseLayoutStr((String)ss[1]);
                if (dd2[0] != 0.0 || dd2[1] == 0.0 && dd2[2] == 0.0) {
                    this.bottomRightPercent.setText(String.format("%.2f", dd2[0] * 100.0));
                }
                if (dd2[1] != 0.0) {
                    this.bottomRightEms.setText(String.format("%.1f", dd2[1]));
                }
                if (dd2[2] != 0.0) {
                    this.bottomRightPx.setText(String.format("%d", (int)dd2[2]));
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    private double parseDouble(String spec, double deft) {
        try {
            return Double.parseDouble(spec);
        }
        catch (NumberFormatException ex) {
            return deft;
        }
    }

    private void formatSpec() {
        double[] dd = new double[]{this.parseDouble(this.topLeftPercent.getText(), 0.0) / 100.0, this.parseDouble(this.topLeftEms.getText(), 0.0), this.parseDouble(this.topLeftPx.getText(), 0.0)};
        String s1 = DasDevicePosition.formatLayoutStr((double[])dd);
        if (this.both) {
            dd[0] = this.parseDouble(this.bottomRightPercent.getText(), 0.0) / 100.0;
            dd[1] = this.parseDouble(this.bottomRightEms.getText(), 0.0);
            dd[2] = this.parseDouble(this.bottomRightPx.getText(), 0.0);
            String s2 = DasDevicePosition.formatLayoutStr((double[])dd);
            this.jTextField1.setText(s1 + "," + s2);
        } else {
            this.jTextField1.setText(s1);
        }
    }

    public void setValue(String v) {
        this.jTextField1.setText(v);
        this.parseSpec();
    }

    public String getValue() {
        return this.jTextField1.getText();
    }

    public Component getComponent() {
        return this;
    }

    public void setContext(Object o) {
    }

    public static void main(String[] args) {
        LayoutStringSchemeEditor edit = new LayoutStringSchemeEditor(true, "");
        edit.setValue("0%+3em,100%-2em");
        JOptionPane.showMessageDialog(null, edit);
    }

    public String getLabel() {
        return "Layout String Editor";
    }
}

